//
//  importPerformanceData.h
//  Golem
//
//  Created by Claus Richter on 4/10/18.
//
//

#import <UIKit/UIKit.h>



@interface importPerformanceData : UIViewController {
    
    NSDictionary *backendDictionaryAircraftData;
    
    int flagWeHaveAnAircraftDictionary;
    int flagWeHaveAbackendID;
    NSString *backendID;
    
    NSMutableArray *arrayACtypesToLoad;
    
    NSMutableArray *arrayDictAllAircraft;
    
    NSMutableArray *arrayLoadedAircraft;
    
    NSMutableArray *performanceChartData;
    
    NSMutableDictionary *chartImagesDictionary;
    
    NSMutableDictionary *ACimagesDictionary;
    
    NSMutableDictionary *manifestLogoDictionary;
    
    NSMutableDictionary *fuelInterpolationDictionary;
    
    
    NSMutableArray *customFilesArray;
    
    NSString *__acCategory;
    NSString *__manufacturer;
    
    
    NSArray *availableHelicopterManufacturers;
    NSArray *availableFixedWingManufacturers;
    
    NSMutableArray *availableCharts;
    NSMutableArray *infoFilesGeneral;
    
    
    
    
    NSArray *array;
    
    NSArray *availableCurves;
    
    
    NSString *arrayKey;
    
    NSString* computationData;
    NSArray *availableComputationsArray;
    
    NSMutableDictionary *computationDictionary;
    
    
    
    
    NSArray *availableCurvesArray;
    
    NSString *importedText;
    
    NSString *serverUrl;
    NSString *customerDataURL;
    NSString *baseDataURL;
    NSString *ACCategory;
    NSString *ACmanufacturer;
    NSString *AC_Type;
    NSString *ACVariant;
    
    
    int flagLoadFromFleetControl;
    
    
    NSString *availableChartsNameUrl;
    NSString *chartName;
    
    
    NSString *chartNameForThisInfoFile;
    
    NSArray *infoArray1;
    NSArray *infoArray2;
    
    
    NSArray *infoArray;
    NSArray *infoPartArray;
    NSArray *curvesArray;
    
    float chartNumber, alertFlag;
    
    NSArray *axisDataArray;
    
    NSArray *chartsArray;
    
    
    
    
    __weak IBOutlet UIImageView *imageView;
    
    NSData *chartImageData; //saved as signatureImage
    
    UIImage *chartImageFile; //
    
    
}

@property (nonatomic, strong)  NSMutableArray * arrayCG1;
@property (nonatomic, strong)  NSMutableArray * arrayCG2;
@property (nonatomic, strong)  NSMutableArray * arrayCG1_LAT;
@property (nonatomic, strong)  NSMutableArray * arrayCG1MarginLine;
@property (nonatomic, strong)  NSMutableArray * arrayCG1_LATline;

@property (strong, nonatomic) IBOutlet UILabel *labelLoadingData;


- (void) loadAvailableACTypesArrayFromDisk;
- (void) loadAvailableACTypesArrayFromFleetControl;
- (void) loadACThumbsAndData;


- (void) loadPerformanceData:(NSString*)dataLocation;


@end

